/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.renderers.geo;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.GeckoLib;
import software.bernie.ars_nouveau.geckolib3.compat.PatchouliCompat;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatableModel;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;
import software.bernie.ars_nouveau.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.ars_nouveau.geckolib3.util.EModelRenderCycle;
import software.bernie.ars_nouveau.geckolib3.util.GeoUtils;
import software.bernie.ars_nouveau.geckolib3.util.IRenderCycle;

public abstract class GeoArmorRenderer<T extends ArmorItem>
extends HumanoidModel
implements IGeoRenderer<T>,
AnimationController.ModelFetcher<T> {
    protected static Map<Class<? extends ArmorItem>, Supplier<GeoArmorRenderer>> CONSTRUCTORS = new ConcurrentHashMap<Class<? extends ArmorItem>, Supplier<GeoArmorRenderer>>();
    public static Map<Class<? extends ArmorItem>, Map<UUID, GeoArmorRenderer<?>>> LIVING_ENTITY_RENDERERS = new ConcurrentHashMap();
    protected Class<? extends ArmorItem> assignedItemClass = null;
    protected T currentArmorItem;
    protected LivingEntity entityLiving;
    protected ItemStack itemStack;
    protected EquipmentSlot armorSlot;
    protected float widthScale;
    protected float heightScale;
    protected Matrix4f dispatchedMat;
    protected Matrix4f renderEarlyMat;
    public String headBone;
    public String bodyBone;
    public String rightArmBone;
    public String leftArmBone;
    public String rightLegBone;
    public String leftLegBone;
    public String rightBootBone;
    public String leftBootBone;
    private final AnimatedGeoModel<T> modelProvider;
    private IRenderCycle currentModelRenderCycle;
    protected MultiBufferSource rtb;

    @Override
    @Nullable
    public IAnimatableModel<T> apply(IAnimatable t) {
        if (t instanceof ArmorItem && t.getClass() == this.assignedItemClass) {
            return this.getGeoModelProvider();
        }
        return null;
    }

    @Deprecated(since="Please use the method that takes in the supplier, this is only present for legacy support")
    public static void registerArmorRenderer(Class<? extends ArmorItem> itemClass, GeoArmorRenderer instance) {
        for (final Constructor<?> c : instance.getClass().getConstructors()) {
            if (c.getParameterCount() != 0) {
                GeckoLib.LOGGER.error("Registration of armor renderer for item class {} failed cause the renderer class {} does not feature a zero-args constructor!", (Object)itemClass.getName(), (Object)instance.getClass().getName());
                throw new IllegalArgumentException("If you still use the registration using instances, please give it a no-args constructor!");
            }
            GeoArmorRenderer.registerArmorRenderer(itemClass, new Supplier<GeoArmorRenderer>(){

                @Override
                public GeoArmorRenderer get() {
                    try {
                        return (GeoArmorRenderer)c.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
    }

    public static void registerArmorRenderer(Class<? extends ArmorItem> itemClass, Supplier<GeoArmorRenderer> rendererConstructor) {
        CONSTRUCTORS.put(itemClass, rendererConstructor);
        LIVING_ENTITY_RENDERERS.put(itemClass, new ConcurrentHashMap());
    }

    public static GeoArmorRenderer getRenderer(Class<? extends ArmorItem> item, Entity wearer) {
        return GeoArmorRenderer.getRenderer(item, wearer, false);
    }

    public static GeoArmorRenderer getRenderer(Class<? extends ArmorItem> item, Entity wearer, boolean forExtendedEntity) {
        Map renderers = LIVING_ENTITY_RENDERERS.putIfAbsent(item, new ConcurrentHashMap());
        if (renderers != null) {
            GeoArmorRenderer renderer = renderers.getOrDefault(wearer.m_142081_(), null);
            if (renderer == null && (renderer = CONSTRUCTORS.get(item).get()) != null) {
                renderer.assignedItemClass = item;
                renderers.put(wearer.m_142081_(), renderer);
            }
            if (renderer == null) {
                throw new IllegalArgumentException("Renderer not registered for item " + item);
            }
            return renderer;
        }
        throw new IllegalArgumentException("Renderer not registered for item " + item);
    }

    public GeoArmorRenderer(AnimatedGeoModel<T> modelProvider) {
        super(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        AnimationController.addModelFetcher(this);
        this.widthScale = 1.0f;
        this.heightScale = 1.0f;
        this.dispatchedMat = new Matrix4f();
        this.renderEarlyMat = new Matrix4f();
        this.headBone = "armorHead";
        this.bodyBone = "armorBody";
        this.rightArmBone = "armorRightArm";
        this.leftArmBone = "armorLeftArm";
        this.rightLegBone = "armorRightLeg";
        this.leftLegBone = "armorLeftLeg";
        this.rightBootBone = "armorRightBoot";
        this.leftBootBone = "armorLeftBoot";
        this.currentModelRenderCycle = EModelRenderCycle.INITIAL;
        this.rtb = null;
        this.modelProvider = modelProvider;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.render(0.0f, matrixStackIn, bufferIn, packedLightIn);
    }

    public void render(float partialTicks, PoseStack stack, VertexConsumer bufferIn, int packedLightIn) {
        stack.m_85837_(0.0, 1.5, 0.0);
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.dispatchedMat = stack.m_85850_().m_85861_().m_27658_();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(this.currentArmorItem));
        AnimationEvent<IAnimatable> itemEvent = new AnimationEvent<IAnimatable>((IAnimatable)this.currentArmorItem, 0.0f, 0.0f, 0.0f, false, Arrays.asList(this.itemStack, this.entityLiving, this.armorSlot));
        this.modelProvider.setLivingAnimations(this.currentArmorItem, this.getUniqueID(this.currentArmorItem), (AnimationEvent)itemEvent);
        this.fitToBiped();
        stack.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(this.currentArmorItem));
        Color renderColor = this.getRenderColor(this.currentArmorItem, partialTicks, stack, null, bufferIn, packedLightIn);
        RenderType renderType = this.getRenderType(this.currentArmorItem, partialTicks, stack, null, bufferIn, packedLightIn, this.getTextureLocation(this.currentArmorItem));
        this.render(model, this.currentArmorItem, partialTicks, renderType, stack, null, bufferIn, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded(stack);
        }
        stack.m_85849_();
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        stack.m_85837_(0.0, -1.5, 0.0);
    }

    @Override
    public void renderEarly(T animatable, PoseStack stackIn, float partialTicks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = stackIn.m_85850_().m_85861_().m_27658_();
        this.currentArmorItem = animatable;
        IGeoRenderer.super.renderEarly(animatable, stackIn, partialTicks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            PoseStack.Pose entry = stack.m_85850_();
            Matrix4f boneMat = entry.m_85861_().m_27658_();
            Matrix4f renderEarlyMatInvert = this.renderEarlyMat.m_27658_();
            renderEarlyMatInvert.m_27657_();
            Matrix4f modelPosBoneMat = boneMat.m_27658_();
            modelPosBoneMat.multiplyBackward(renderEarlyMatInvert);
            bone.setModelSpaceXform(modelPosBoneMat);
            Matrix4f dispatchedMatInvert = this.dispatchedMat.m_27658_();
            dispatchedMatInvert.m_27657_();
            Matrix4f localPosBoneMat = boneMat.m_27658_();
            localPosBoneMat.multiplyBackward(dispatchedMatInvert);
            Vec3 renderOffset = this.getRenderOffset(this.currentArmorItem, 1.0f);
            localPosBoneMat.m_27648_(new Vector3f((float)renderOffset.m_7096_(), (float)renderOffset.m_7098_(), (float)renderOffset.m_7094_()));
            bone.setLocalSpaceXform(localPosBoneMat);
            Matrix4f worldPosBoneMat = localPosBoneMat.m_27658_();
            worldPosBoneMat.m_27648_(new Vector3f((float)Minecraft.m_91087_().f_91075_.m_20185_(), (float)Minecraft.m_91087_().f_91075_.m_20186_(), (float)Minecraft.m_91087_().f_91075_.m_20189_()));
            bone.setWorldSpaceXform(worldPosBoneMat);
        }
        IGeoRenderer.super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public Vec3 getRenderOffset(T pEntity, float pPartialTicks) {
        return Vec3.f_82478_;
    }

    protected void fitToBiped() {
        if (this.headBone != null) {
            IBone headBone = this.modelProvider.getBone(this.headBone);
            GeoUtils.copyRotations(this.f_102808_, headBone);
            headBone.setPositionX(this.f_102808_.f_104200_);
            headBone.setPositionY(-this.f_102808_.f_104201_);
            headBone.setPositionZ(this.f_102808_.f_104202_);
        }
        if (this.bodyBone != null) {
            IBone bodyBone = this.modelProvider.getBone(this.bodyBone);
            GeoUtils.copyRotations(this.f_102810_, bodyBone);
            bodyBone.setPositionX(this.f_102810_.f_104200_);
            bodyBone.setPositionY(-this.f_102810_.f_104201_);
            bodyBone.setPositionZ(this.f_102810_.f_104202_);
        }
        if (this.rightArmBone != null) {
            IBone rightArmBone = this.modelProvider.getBone(this.rightArmBone);
            GeoUtils.copyRotations(this.f_102811_, rightArmBone);
            rightArmBone.setPositionX(this.f_102811_.f_104200_ + 5.0f);
            rightArmBone.setPositionY(2.0f - this.f_102811_.f_104201_);
            rightArmBone.setPositionZ(this.f_102811_.f_104202_);
        }
        if (this.leftArmBone != null) {
            IBone leftArmBone = this.modelProvider.getBone(this.leftArmBone);
            GeoUtils.copyRotations(this.f_102812_, leftArmBone);
            leftArmBone.setPositionX(this.f_102812_.f_104200_ - 5.0f);
            leftArmBone.setPositionY(2.0f - this.f_102812_.f_104201_);
            leftArmBone.setPositionZ(this.f_102812_.f_104202_);
        }
        if (this.rightLegBone != null) {
            IBone rightLegBone = this.modelProvider.getBone(this.rightLegBone);
            GeoUtils.copyRotations(this.f_102813_, rightLegBone);
            rightLegBone.setPositionX(this.f_102813_.f_104200_ + 2.0f);
            rightLegBone.setPositionY(12.0f - this.f_102813_.f_104201_);
            rightLegBone.setPositionZ(this.f_102813_.f_104202_);
            if (this.rightBootBone != null) {
                IBone rightBootBone = this.modelProvider.getBone(this.rightBootBone);
                GeoUtils.copyRotations(this.f_102813_, rightBootBone);
                rightBootBone.setPositionX(this.f_102813_.f_104200_ + 2.0f);
                rightBootBone.setPositionY(12.0f - this.f_102813_.f_104201_);
                rightBootBone.setPositionZ(this.f_102813_.f_104202_);
            }
        }
        if (this.leftLegBone != null) {
            IBone leftLegBone = this.modelProvider.getBone(this.leftLegBone);
            GeoUtils.copyRotations(this.f_102814_, leftLegBone);
            leftLegBone.setPositionX(this.f_102814_.f_104200_ - 2.0f);
            leftLegBone.setPositionY(12.0f - this.f_102814_.f_104201_);
            leftLegBone.setPositionZ(this.f_102814_.f_104202_);
            if (this.leftBootBone != null) {
                IBone leftBootBone = this.modelProvider.getBone(this.leftBootBone);
                GeoUtils.copyRotations(this.f_102814_, leftBootBone);
                leftBootBone.setPositionX(this.f_102814_.f_104200_ - 2.0f);
                leftBootBone.setPositionY(12.0f - this.f_102814_.f_104201_);
                leftBootBone.setPositionZ(this.f_102814_.f_104202_);
            }
        }
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    @Nonnull
    @ApiStatus.AvailableSince(value="3.0.42")
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getWidthScale(T entity) {
        return this.widthScale;
    }

    @Override
    @ApiStatus.AvailableSince(value="3.0.42")
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    public GeoArmorRenderer setCurrentItem(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot) {
        this.entityLiving = entityLiving;
        this.itemStack = itemStack;
        this.armorSlot = armorSlot;
        this.currentArmorItem = (ArmorItem)itemStack.m_41720_();
        return this;
    }

    public final GeoArmorRenderer applyEntityStats(HumanoidModel defaultArmor) {
        this.f_102610_ = defaultArmor.f_102610_;
        this.f_102817_ = defaultArmor.f_102817_;
        this.f_102609_ = defaultArmor.f_102609_;
        this.f_102816_ = defaultArmor.f_102816_;
        this.f_102815_ = defaultArmor.f_102815_;
        return this;
    }

    public GeoArmorRenderer applySlot(EquipmentSlot slot) {
        this.modelProvider.getModel(this.modelProvider.getModelLocation(this.currentArmorItem));
        IBone headBone = this.getAndHideBone(this.headBone);
        IBone bodyBone = this.getAndHideBone(this.bodyBone);
        IBone rightArmBone = this.getAndHideBone(this.rightArmBone);
        IBone leftArmBone = this.getAndHideBone(this.leftArmBone);
        IBone rightLegBone = this.getAndHideBone(this.rightLegBone);
        IBone leftLegBone = this.getAndHideBone(this.leftLegBone);
        IBone rightBootBone = this.getAndHideBone(this.rightBootBone);
        IBone leftBootBone = this.getAndHideBone(this.leftBootBone);
        switch (slot) {
            case HEAD: {
                if (headBone == null) break;
                headBone.setHidden(false);
                break;
            }
            case CHEST: {
                if (bodyBone != null) {
                    bodyBone.setHidden(false);
                }
                if (rightArmBone != null) {
                    rightArmBone.setHidden(false);
                }
                if (leftArmBone == null) break;
                leftArmBone.setHidden(false);
                break;
            }
            case LEGS: {
                if (rightLegBone != null) {
                    rightLegBone.setHidden(false);
                }
                if (leftLegBone == null) break;
                leftLegBone.setHidden(false);
                break;
            }
            case FEET: {
                if (rightBootBone != null) {
                    rightBootBone.setHidden(false);
                }
                if (leftBootBone == null) break;
                leftBootBone.setHidden(false);
            }
        }
        return this;
    }

    protected IBone getAndHideBone(String boneName) {
        if (boneName != null) {
            IBone bone = this.modelProvider.getBone(boneName);
            bone.setHidden(true);
            return bone;
        }
        return null;
    }

    @Override
    public Integer getUniqueID(T animatable) {
        return Objects.hash(this.armorSlot, this.itemStack.m_41720_(), this.itemStack.m_41613_(), this.itemStack.m_41782_() ? this.itemStack.m_41783_().toString() : Integer.valueOf(1), this.entityLiving.m_142081_().toString());
    }

    @Override
    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }
}

